#!/bin/bash
#Audioblast enter USERNAME & SERIAL

if [ $SUDO_USER ]; then
    user=$SUDO_USER
else
    user=$(whoami)
fi


AUDIOBLASTDIR="/home/$user/.audioblast"
if [ ! -d "$AUDIOBLASTDIR" ]; then
  #echo "$AUDIOBLASTDIR does not exist, creating !"
  mkdir -m 777 -p $AUDIOBLASTDIR
fi


RG3DIR="$AUDIOBLASTDIR/DrumBlaster"
if [ ! -d "$RG3DIR" ]; then
  #echo "$RG3DIR does not exist, creating !"
  mkdir -m 777 -p $RG3DIR
fi

cp -r "Presets" $RG3DIR
cp -r "Samples" $RG3DIR

COMPANY="Audioblast"
PLUGINNAME="DrumBlaster"
VST3PRESETCOMPANYDIR="$HOME/.vst3/presets/$COMPANY"
if [ ! -d "$VST3PRESETCOMPANYDIR" ]; then
  #echo "$VST3PRESETCOMPANYDIR does not exist, creating !"
  mkdir -m 777 -p $VST3PRESETCOMPANYDIR
fi

VST3PRESETPLUGINDIR="$VST3PRESETCOMPANYDIR/$PLUGINNAME"
if [ ! -d "$VST3PRESETPLUGINDIR" ]; then
  #echo "$VST3PRESETPLUGINDIR does not exist, creating !"
  mkdir -m 777 -p $VST3PRESETPLUGINDIR
fi

cp -r Presets/. $VST3PRESETPLUGINDIR 

exit
